<?php

$DB_NAME = 'reserve';
$DB_HOST = 'mysql';
$DB_USER = 'root';
$DB_PASS = 'F7m9dSz0';

$linkID = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);

if (mysqli_connect_errno()) {
   printf("Connect failed: %s\n", mysqli_connect_error());
   exit();
}

// begin class
class FridayReport {
   // Begin Class
   public $linkID;

   function __construct($linkID){ $this->linkID = $linkID; }

   public function new_mysql($sql) {
      $result = $this->linkID->query($sql) or die($this->linkID->error.__LINE__);
      return $result;
   }

	public function get_data($week1,$week2,$year) {

		$sql = "
		SELECT
			`reservations`.`reservationID`,
			DATE_FORMAT(`reservations`.`reservation_date`,'%m/%d/%Y') AS `reservation_date`,
			COUNT(`inventory`.`inventoryID`) AS 'total_pax'

		FROM
			`reservations`,`inventory`

		WHERE
			WEEK(`reservations`.`reservation_date`,'1') BETWEEN '$week1' AND '$week2'
			AND DATE_FORMAT(`reservations`.`reservation_date`, '%Y') = '$year'
			AND `reservations`.`reservationID` = `inventory`.`reservationID`
			AND `inventory`.`status` IN ('booked','tentative')

		GROUP BY `inventory`.`reservationID`

		ORDER BY `reservations`.`reservationID`

		";


		$result = $this->new_mysql($sql);
		while ($row = $result->fetch_assoc()) {
			$total_reservations++;
			$total_pax = $total_pax + $row['total_pax'];
		}

		$data = array();
		$data[0] = $total_reservations;
		$data[1] = $total_pax;
		return $data;

	}

	public function get_data_that_week($week1,$week2,$year) {

		$sql = "
		(
      SELECT
         `reservations`.`reservationID`,
         DATE_FORMAT(`reservations`.`reservation_date`,'%m/%d/%Y') AS `date`,
         COUNT(`inventory`.`inventoryID`) AS 'total_pax',
			DATE_FORMAT(`charters`.`start_date`, '%m/%d/%Y') AS 'start_date',
			`boats`.`name`,
			`resellers`.`company`,
			`users`.`first`,
			`users`.`last`,
			`countries`.`country`,
			`reservations`.`cancel_reason`,
			'active' AS 'status'

      FROM
         `reservations`,`inventory`,`charters`,`boats`,`reseller_agents`,`contacts`,`resellers`,`users`

		LEFT JOIN countries ON countries.countryID = contacts.countryID

      WHERE
         WEEK(`reservations`.`reservation_date`,'1') BETWEEN '$week1' AND '$week2'
         AND DATE_FORMAT(`reservations`.`reservation_date`, '%Y') = '$year'
         AND `reservations`.`reservationID` = `inventory`.`reservationID`
         AND `inventory`.`status` IN ('booked','tentative')
			AND `reservations`.`charterID` = `charters`.`charterID`
			AND `charters`.`boatID` = `boats`.`boatID`
			AND `reservations`.`reseller_agentID` = `reseller_agents`.`reseller_agentID`
			AND `reseller_agents`.`resellerID` = `resellers`.`resellerID`
			AND `reservations`.`reservation_contactID` = `contacts`.`contactID`
			AND `reservations`.`userID` = `users`.`userID`

      GROUP BY `inventory`.`reservationID`

      ORDER BY `reservations`.`reservationID`
		)
		UNION
		(
      SELECT
         DISTINCT `reservations`.`reservationID`,
         DATE_FORMAT(`reservations`.`cancel_date`,'%m/%d/%Y') AS `date`,
         COUNT(DISTINCT `suspended_inventory`.`contactID`) AS 'total_pax',
			DATE_FORMAT(`charters`.`start_date`,'%m/%d/%Y') AS 'start_date',
			`boats`.`name`,
			`resellers`.`company`,
			`users`.`first`,
			`users`.`last`,
			`countries`.`country`,
			`reservations`.`cancel_reason`,
			'cancelled' AS 'status'

      FROM
         `reservations`,`suspended_inventory`,`charters`,`boats`,`reseller_agents`,`resellers`,`contacts`,`users`

		LEFT JOIN countries ON countries.countryID = contacts.countryID

      WHERE
         WEEK(`reservations`.`cancel_date`,'1') BETWEEN '$week1' AND '$week2'
         AND DATE_FORMAT(`reservations`.`cancel_date`, '%Y') = '$year'
         AND `reservations`.`reservationID` = `suspended_inventory`.`reservationID`
			AND `reservations`.`charterID` = `charters`.`charterID`
			AND `charters`.`boatID` = `boats`.`boatID`
			AND `reservations`.`reseller_agentID` = `reseller_agents`.`reseller_agentID`
			AND `reseller_agents`.`resellerID` = `resellers`.`resellerID`
			AND `reservations`.`reservation_contactID` = `contacts`.`contactID`
			AND `reservations`.`userID` = `users`.`userID`

      GROUP BY `suspended_inventory`.`reservationID`

      ORDER BY `reservations`.`reservationID`
		)

		ORDER BY `date` ASC

		";
		$result = $this->new_mysql($sql);
		while ($row = $result->fetch_assoc()) {
			switch ($row['status']) {
				case "active":
					$html .= "
					<tr>
						<td>$row[date]</td>
						<td><a href=\"https://reservations.aggressor.com/reservation_manage_single_reservation.php?reservationID=$row[reservationID]\">$row[reservationID]</a></td>
						<td>$row[name]</td>
						<td>$row[first] $row[last]</td>
						<td>$row[start_date]</td>
						<td>$row[total_pax]</td>
						<td>$row[company]</td>
						<td>$row[cancel_reason]&nbsp;</td>
						<td>$row[country]</td>
					</tr>";
				break;
				case "cancelled":
               $html .= "
               <tr>
                  <td><font color=red>$row[date]</font></td>
                  <td><a href=\"https://reservations.aggressor.com/reservation_manage_single_reservation.php?reservationID=$row[reservationID]\">$row[reservationID]</a></td>
                  <td>$row[name]</td>
                  <td>$row[first] $row[last]</td>
                  <td>$row[start_date]</td>
                  <td><font color=red>-$row[total_pax]</font></td>
                  <td>$row[company]</td>
                  <td>$row[cancel_reason]&nbsp;</td>
                  <td>$row[country]</td>
               </tr>";
				break;
			}
		}

		return $html;
	}

	public function get_data_details($week1,$week2,$year) {

		$sql = "
      SELECT
         `reservations`.`reservationID`,
         DATE_FORMAT(`reservations`.`reservation_date`,'%a') AS `reservation_date`,
         COUNT(`inventory`.`inventoryID`) AS 'total_pax'

      FROM
         `reservations`,`inventory`

      WHERE
         WEEK(`reservations`.`reservation_date`,'1') BETWEEN '$week1' AND '$week2'
         AND DATE_FORMAT(`reservations`.`reservation_date`, '%Y') = '$year'
         AND `reservations`.`reservationID` = `inventory`.`reservationID`
         AND `inventory`.`status` IN ('booked','tentative')

      GROUP BY `inventory`.`reservationID`

      ORDER BY `reservations`.`reservationID`
		";
		//print "SQL: $sql<br>";

		// init vars
		$mon = "0"; $tue = "0"; $wed = "0"; $thu = "0"; $fri = "0"; $sat = "0"; $sun = "0";

      $result = $this->new_mysql($sql);
      while ($row = $result->fetch_assoc()) {
			switch ($row['reservation_date']) {
				case "Mon":
				$mon = $mon + $row['total_pax'];
				break;

				case "Tue":
				$tue = $tue + $row['total_pax'];
				break;

				case "Wed":
				$wed = $wed + $row['total_pax'];
				break;

				case "Thu":
				$thu = $thu + $row['total_pax'];
				break;

				case "Fri":
				$fri = $fri + $row['total_pax'];
				break;

				case "Sat":
				$sat = $sat + $row['total_pax'];
				break;

				case "Sun":
				$sun = $sun + $row['total_pax'];
				break;
			}
		}

		//print "Data: $mon, $tue, $wed, $thu, $fri, $sat, $sun<br>";

		$data = array();
		$data[] = $mon;
		$data[] = $tue;
		$data[] = $wed;
		$data[] = $thu;
		$data[] = $fri;
		$data[] = $sat;
		$data[] = $sun;
		return $data;

	}

	public function get_cxl_data($week1,$week2,$year) {

		$sql = "
      SELECT
         DISTINCT `reservations`.`reservationID`,
         DATE_FORMAT(`reservations`.`cancel_date`,'%m/%d/%Y') AS `cancel_date`,
         COUNT(DISTINCT `suspended_inventory`.`contactID`) AS 'total_pax'

      FROM
         `reservations`,`suspended_inventory`

      WHERE
         WEEK(`reservations`.`cancel_date`,'1') BETWEEN '$week1' AND '$week2'
         AND DATE_FORMAT(`reservations`.`cancel_date`, '%Y') = '$year'
         AND `reservations`.`reservationID` = `suspended_inventory`.`reservationID`

      GROUP BY `suspended_inventory`.`reservationID`

      ORDER BY `reservations`.`reservationID`

		";

      $result = $this->new_mysql($sql);
      while ($row = $result->fetch_assoc()) {
         $total_reservations++;
         $total_pax = $total_pax + $row['total_pax'];
      }

      $data = array();
      $data[0] = $total_reservations;
      $data[1] = $total_pax;
      return $data;

	}


   public function bar_graph($data,$labels,$title) {
      require_once ('jpgraph/src/jpgraph.php');
      require_once ('jpgraph/src/jpgraph_bar.php');


      // Create the graph. These two calls are always required
      $graph = new Graph(600,300);
      $graph->SetScale('textlin');

      // Add a drop shadow
      $graph->SetShadow();

      // Adjust the margin a bit to make more room for titles
      $graph->SetMargin(80,140,20,40);

      // Create a bar pot
      $bplot = new BarPlot($data);
      $graph->Add($bplot);

      //$bplot->SetFillColor(array('purple','blue','green','orange','red'));
      //$graph->Add($bplot);


      // Setup the titles
      $graph->title->Set($title);
      $graph->yaxis->title->SetMargin(15);
      $graph->xaxis->title->Set('Days');
      $graph->yaxis->title->Set('Passengers');
      $graph->xaxis->SetTickLabels($labels);

      $graph->title->SetFont(FF_FONT1,FS_BOLD);
      $graph->yaxis->title->SetFont(FF_FONT1,FS_BOLD);
      $graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD);

      // Display the graph
      //$graph->Stroke();
      $gdImgHandler = $graph->Stroke(_IMG_HANDLER);
      $rand = date("U");
      $rand .= rand(50,600);
      $fileName = ".output/$rand.png";
      $graph->img->Stream($fileName);
      $image = "<img src=\"http://www.liveaboardfleet.com/admin/reports/2.0/$fileName\">";
      return $image;
   }

   public function line_graph($pax,$cxl,$lbl,$title) {
      require_once ('jpgraph/src/jpgraph.php');
      require_once ('jpgraph/src/jpgraph_line.php');


      // Create the graph and specify the scale for both Y-axis
      $graph = new Graph(1200,300);
      $graph->SetScale('textlin');
      //$graph->SetY2Scale('lin');
      $graph->SetShadow();

      // Adjust the margin
      $graph->img->SetMargin(80,140,20,40);

      // Create the two linear plot
      if (is_array($pax)) {
         $lineplot1=new LinePlot($pax);
      }
      if (is_array($cxl)) {
         $lineplot2=new LinePlot($cxl);
      }

      // Add the plot to the graph
      if (is_array($pax)) {
         $graph->Add($lineplot1);
         $lineplot1->SetColor('blue');
         $lineplot1->SetWeight(2);
         $lineplot1->SetLegend('PAX');
      }
      if (is_array($cxl)) {
         $graph->Add($lineplot2);
         $lineplot2->SetColor('red');
         $lineplot2->SetWeight(2);
         $lineplot2->SetLegend('CXL');
      }
      $graph->title->Set($title);
      $graph->xaxis->SetTickLabels($lbl);
      $graph->yaxis->title->SetMargin(15);
      $graph->xaxis->title->Set('Weeks');
      $graph->yaxis->title->Set('Passengers');
		$graph->xaxis->SetLabelAngle(45);
      //$graph->yaxis->SetTitleMargin(.9);

      $graph->title->SetFont(FF_FONT1,FS_BOLD);
      $graph->yaxis->title->SetFont(FF_FONT1,FS_BOLD);
      $graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD);

      // Adjust the legend position
      $graph->legend->SetColumns('1');
      $graph->legend->Pos(0.05,0.5,'right','top');

      // Display the graph
      //$graph->Stroke();
      $gdImgHandler = $graph->Stroke(_IMG_HANDLER);
      $rand = date("U");
      $rand .= rand(50,500);
      $fileName = ".output/$rand.png";
      $graph->img->Stream($fileName);
      $image = "<img src=\"http://www.liveaboardfleet.com/admin/reports/2.0/$fileName\">";
      return $image;
   }

}
// end class

$FridayReport = new FridayReport($linkID);

$this_week = date("W") - 1;
$this_year = date("Y");
//die($this_year);

$week_dif = 52 - $this_week;
$last_year = $this_year-1;

$week_start = new DateTime();

for ($x=$this_week; $x > 0; $x=$x-1) {
	$data = $FridayReport->get_data($x,$x,$this_year);
	$data2 = $FridayReport->get_cxl_data($x,$x,$this_year);

	$x2 = $x;
	$week_start->setISODate($this_year,$x2);

   // bar graph
   if ($first_graph == "") {
      $bar_array = $FridayReport->get_data_details($x,$x,$this_year);
      $labels = array();
      $labels[] = "Mon";
      $labels[] = "Tue";
      $labels[] = "Wed";
      $labels[] = "Thu";
      $labels[] = "Fri";
      $labels[] = "Sat";
      $labels[] = "Sun";

		//print_r($bar_array);

      $title = "Passengers Booked Week $x - ".$week_start->format('M d, Y')." (Mon - Sun)"; 
      $bg1 = $FridayReport->bar_graph($bar_array,$labels,$title);
      $first_graph = "1";

		// capture details
		$html = $FridayReport->get_data_that_week($x,$x,$this_year);
   }


	$diff_data = $data[1] - $data2[1];
	$output .= "<tr><td>$x (".$week_start->format('M d, Y').")</td><td>$data[1]</td><td>$data2[1]</td><td>$diff_data</td></tr>";
	$line_graph_pax[] = $data[1];
	$line_graph_cxl[] = $data2[1];
	$line_graph_lbl[] = $x;

}

if ($week_dif > 0) {
	$week_dif2 = 52 - $week_dif;
	for ($x=52; $x > $week_dif2; $x=$x-1) {

   	$data = $FridayReport->get_data($x,$x,$last_year);
		$data2 = $FridayReport->get_cxl_data($x,$x,$last_year);
	   $x2 = $x;
   	$week_start->setISODate($last_year,$x2);
		$diff_data = $data[1] - $data2[1];
	   $output .= "<tr><td>$x (".$week_start->format('M d, Y').")</td><td>$data[1]</td><td>$data2[1]</td><td>$diff_data</td></tr>";
	   $line_graph_pax[] = $data[1];
   	$line_graph_cxl[] = $data2[1];
	   $line_graph_lbl[] = $x;

	}
}

// line graph
$title = "52 Weeks Booked PAX/CXL Prior Week + 51 Weeks Prior";
$lg1 = $FridayReport->line_graph($line_graph_pax,$line_graph_cxl,$line_graph_lbl,$title);

$today = date("m/d/Y");
$msg = "
<center><h2>Booked PAX/CXL Report - $today</h2></center>
<table border=0 width=80%>
<tr><td>$bg1$lg1</td></tr>
</table><br>
<table border=1 width=80%>
<tr bgcolor=\"#A4A4A4\">
	<td><b>Week # (Mon-Sun)</b></td>
	<td><b>Pax Booked</b></td>
	<td><b>Pax Cxl</b></td>
	<td><b>NET Pax Booked/Cxl</b></td>
</tr>
$output

</table>";

$msg .= "
<table border=1 width=80%>
<tr bgcolor=\"#A4A4A4\">
	<td><b>Date</b></td>
	<td><b>Res ID</b></td>
	<td><b>Yacht</b></td>
	<td><b>Booker</b></td>
	<td><b>Dept Date</b></td>
	<td><b>Pax/CXL</b></td>
	<td><b>Reseller</b></td>
	<td><b>Cxl Reason</b></td>
	<td><b>Country</b></td>
</tr>
$html
</table>";
//die($html);
		$subject = "AA Booked PAX/CXL Report";

      // email headers - This is fine tuned, please do not modify
      $header2 = "MIME-Version: 1.0\r\n";
      $header2 .= "Content-type: text/html; charset=iso-8859-1\r\n";
      $header2 .= "From: AA Reports <info@aggressor.com>\r\n";
      $header2 .= "Reply-To: AA Reports <info@aggressor.com>\r\n";
      $header2 .= "X-Priority: 3\r\n";
      $header2 .= "X-Mailer: PHP/" . phpversion()."\r\n";
      //mail("robert@wayneworks.com",$subject,$msg,$header2);
      mail("BookedCanceled@aggressor.com",$subject,$msg,$header2);
	//	mail('rich@aggressor.com',$subject,$msg,$header2);	
	//print "$msg";


?>
