<?php

$DB_NAME = 'reserve';
$DB_HOST = 'mysql';
$DB_USER = 'root';
$DB_PASS = 'F7m9dSz0';

$linkID = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);

if (mysqli_connect_errno()) {
   printf("Connect failed: %s\n", mysqli_connect_error());
   exit();
}

// begin class
class ResReport {
   // Begin Class
   public $linkID;

   function __construct($linkID){ $this->linkID = $linkID; }

   public function new_mysql($sql) {
      $result = $this->linkID->query($sql) or die($this->linkID->error.__LINE__);
      return $result;
   }

	public function get_crs_data($boatID) {
		$sql = "
		SELECT
			`r`.`reservationID`,
			count(`inventory`.`reservationID`) AS 'PAX',
			DATE_FORMAT(`r`.`reservation_date`, '%b') AS 'month',
			DATE_FORMAT(`r`.`reservation_date`, '%Y') AS 'year'

		FROM
			`reservations` r, `inventory`, `charters`

		WHERE
			`r`.`reseller_agentID` = '86505023'
			AND `r`.`show_as_suspended` = '0'
			AND `r`.`reservationID` = `inventory`.`reservationID`
			AND `r`.`charterID` = `charters`.`charterID`
			AND `charters`.`boatID` = '$boatID'

		GROUP BY `r`.`reservationID`
		";
		$result = $this->new_mysql($sql);
		while ($row = $result->fetch_assoc()) {
			if($row['year']>2015)
			{
			$month = $row['month'] . " " . $row['year'];
			$array_month[$month] = $array_month[$month] + $row['PAX'];
			}	
	}
		return $array_month;
	}

   public function crs_line_graph($data,$labels,$title) {
      require_once ('jpgraph/src/jpgraph.php');
      require_once ('jpgraph/src/jpgraph_line.php');

      
      // Create the graph and specify the scale for both Y-axis
      $graph = new Graph(800,400);
      $graph->SetScale('textlin');
      //$graph->SetY2Scale('lin');
      $graph->SetShadow();
     
		$graph->SetFrame(true,'blue',3);
 
      // Adjust the margin
      $graph->img->SetMargin(80,140,20,40);
      
      // Create the two linear plot
      if (is_array($data)) {
         $lineplot1=new LinePlot($data);
      }
      
      // Add the plot to the graph
      if (is_array($data)) {
         $graph->Add($lineplot1);
         $lineplot1->SetColor('blue');
         $lineplot1->SetWeight(2);
         $lineplot1->SetLegend('PAX');
      }
      $graph->title->Set($title);
      $graph->xaxis->SetTickLabels($labels);
      $graph->yaxis->title->SetMargin(15);
      $graph->xaxis->title->Set('Month');
      $graph->yaxis->title->Set('Passengers');
      //$graph->yaxis->SetTitleMargin(.9);

      $graph->title->SetFont(FF_FONT1,FS_BOLD);
      $graph->yaxis->title->SetFont(FF_FONT1,FS_BOLD);
      $graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD);


		$graph->subtitle->SetFont(FF_ARIAL,FS_NORMAL,10);
		$graph->subtitle->SetColor('darkred');
		$graph->subtitle->Set('"Online Reservations"');

      // Adjust the legend position
      $graph->legend->SetColumns('1');
      $graph->legend->Pos(0.05,0.5,'right','top');

		$graph->SetAxisLabelBackground(LABELBKG_NONE,'orange','red','lightblue','red');

		$graph->xaxis->SetFont(FF_ARIAL,FS_NORMAL,9);
		$graph->yaxis->SetFont(FF_ARIAL,FS_NORMAL,9);

		$graph->xgrid->Show();

      // Display the graph
      //$graph->Stroke();
      $gdImgHandler = $graph->Stroke(_IMG_HANDLER);
      $rand = date("U");
      $rand .= rand(50,500);
      $fileName = ".output/$rand.png";
      $graph->img->Stream($fileName);
      $image = "<img src=\"http://www.liveaboardfleet.com/admin/reports/2.0/$fileName\">";
      return $image;
   }



}



$ResReport = new ResReport($linkID);

$today = date("m/d/Y");
$html .= "<b>CRS Report By Destination $today</b><br><br>";


// CRS
$sql = "SELECT `boatID`,`name` FROM `boats` WHERE `status` = 'Active' and `boatID` not in (40,41) ORDER BY `name` ASC";
$result = $ResReport->new_mysql($sql);
while ($row = $result->fetch_assoc()) {
	$crs = $ResReport->get_crs_data($row['boatID']);
	$html .= "<h2>$row[name]</h2>";
	
	if (is_array($crs)) {
		$html .= "<table border=0 width=300>
		<tr><td width=150><b>Date</b></td><td width=150><b>PAX</b></td></tr>";
		foreach ($crs as $key=>$value) {
			$html .= "<tr><td>$key</td><td>$value</td></tr>";
		}
		$html .= "</table>";
	}
	//print "<pre>";
	//print_r($crs);
	//print "</pre>";
}

/*
foreach ($crs as $key=>$value) {
	$data[] = $value;
	$labels[] = $key;
}
*/



$subject = "AF CRS Report By Destination";
      // email headers - This is fine tuned, please do not modify
      $header2 = "MIME-Version: 1.0\r\n";
      $header2 .= "Content-type: text/html; charset=iso-8859-1\r\n";
      $header2 .= "From: AF/DF Reports <info@aggressor.com>\r\n";
      $header2 .= "Reply-To: AF/DF Reports <info@aggressor.com>\r\n";
      $header2 .= "X-Priority: 3\r\n";
      $header2 .= "X-Mailer: PHP/" . phpversion()."\r\n";
     // mail("rich@aggressor.com",$subject,$html,$header2);
      mail("anne@aggressor.com, wayne@wayneworks.com, wayne@aggressor.com, larry@aggressor.com, tom@liveaboardfleet.com, cole@aggressor.com",$subject,$html,$header2);



?>
